const { Router } = require("express");
const {
  obtenerVendedores,
  crearVendedor,
  obtenerVendedorPorId,
  enviarCredenciales,
  actualizarVendedor,
  eliminarUsuario,
} = require("../controllers/Vendedores.Controller");

const router = Router();

router.get("/:identificador", obtenerVendedores);
router.get("/:id/byId", obtenerVendedorPorId);

router.put("/:id", actualizarVendedor);

router.post("/accesos", enviarCredenciales);
router.post("/", crearVendedor);

router.delete("/:id", eliminarUsuario);

module.exports = router;
