const { Router } = require('express');
const { actualizarUsuario, obtenerUsuarios, obtenerUsuariosSinPaginar, createUsuario, obtenerUsuario, updateUsuario, deleteUsuario } = require('../controllers/Usuarios.Psd.Controller.js');
const router = Router();

router.get('/', obtenerUsuarios);
router.get('/:despacho/sin-paginar', obtenerUsuariosSinPaginar);
router.get('/:id/by-id', obtenerUsuario);

router.post('/', createUsuario);
router.put('/:id', actualizarUsuario);

router.patch('/:id', updateUsuario);
router.delete('/:id', deleteUsuario);

module.exports = router;
