const { Router } = require("express");
const {
  actualizarUsuario,
  obtenerUsuarios,
  obtenerUsuariosSinPaginar,
  createUsuarioDespacho,
  obtenerUsuario,
  updateUsuario,
  deleteUsuario,
  cargaUsuario,
} = require("../controllers/Usuarios.Controller.js");
const router = Router();

router.get("/:despacho", obtenerUsuarios);
router.get("/:despacho/sin-paginar", obtenerUsuariosSinPaginar);
router.get("/:id/by-id", obtenerUsuario);
router.get("/carga/:usuario", cargaUsuario);

router.post("/:despacho", createUsuarioDespacho);
router.put("/:id", actualizarUsuario);

router.patch("/:id", updateUsuario);
router.delete("/:id", deleteUsuario);

module.exports = router;
