const { Router } = require('express');
const { obtenerTesis, obtenerTesisByID, descargarTesisById, imprimirTesisById, obtenerVotosByID, imprimirVotosById, descargarVotosById, obtenerPrecedenteBydId, descargarPrecedenteById, imprimirPrecedenteById } = require('../controllers/Tesis.controller');

const router = Router();

router.get('/tesis/:id', obtenerTesisByID);
router.post('/tesis/', obtenerTesis);
router.get('/tesis/descargar/:id', descargarTesisById);
router.get('/tesis/imprimir/:id', imprimirTesisById);

router.get('/votos/:id', obtenerVotosByID);
router.get('/votos/descargar/:id', descargarVotosById);
router.get('/votos/imprimir/:id', imprimirVotosById);

router.get('/precedente/imprimir/:id', imprimirPrecedenteById);
router.get('/precedente/descargar/:id', descargarPrecedenteById);
router.get('/precedente/:id', obtenerPrecedenteBydId);

module.exports = router;
