const { Router } = require('express');
const { getRecursosIncidenciasMateria, getRecursosOrIncidentes, getRecursoOrIncidenciaById, updateRecursoOrIncidencia, newRecursoIncidencia, deleteRecursoOrIncidencia } = require('../controllers/Recursos.Incidencias.Controller.js');

const router = Router();

router.get('/', getRecursosOrIncidentes);
router.get('/:id', getRecursoOrIncidenciaById);
router.get('/:materia', getRecursosIncidenciasMateria);

router.put('/:id', updateRecursoOrIncidencia);

router.post('/', newRecursoIncidencia);

router.delete('/:id', deleteRecursoOrIncidencia);
module.exports = router;
