const { Router } = require('express');
const { getRecursos, getRecursosSinPaginar, createRecurso, getRecursoById, updateRecurso, deleteRecurso } = require('../controllers/Recursos.Despachos.Controller');

const router = Router();

router.get('/:despacho/sin-paginar', getRecursosSinPaginar);
router.get('/:despacho', getRecursos);
router.post('/:despacho', createRecurso);
router.get('/:despacho/by-id/:id', getRecursoById);
router.put('/:despacho/by-id/:id', updateRecurso);
router.delete('/:despacho/by-id/:id', deleteRecurso);

module.exports = router;
