const { Router } = require('express');
const { getDistribuidoresAdmin, createDistribuidor, updateDistribuidor, updateEstatus, getDistribuidorById, getVentasByDistribuidores, getDistribuidoresSinPaginar } = require('../controllers/Distribuidores.Psd.Controller');

const router = Router();

router.get('/', getDistribuidoresAdmin);
router.get('/ventas-distribuidor/:usuario', getVentasByDistribuidores);
router.get('/sin-paginar', getDistribuidoresSinPaginar);
router.get('/:id', getDistribuidorById);

router.post('/', createDistribuidor);

router.put('/:_id', updateDistribuidor);
router.patch('/estatus', updateEstatus);

module.exports = router;
