const { Router } = require('express');
const { getProspectoSinPaginar, getProspectos, getProspecto, updateProspecto, createProspecto, deleteProspecto } = require('../controllers/Prospectos.Despachos.Controller.js');

const router = Router();

router.get('/:despacho/sin-paginar', getProspectoSinPaginar);
router.get('/:despacho', getProspectos);
router.get('/:despacho/:id', getProspecto);

router.patch('/:id', updateProspecto);

router.post('/:despacho', createProspecto);
router.delete('/:id', deleteProspecto);

module.exports = router;
