const { Router } = require("express");
const {
  getProspectos,
  addCountProspecto,
  createProspecto,
  updateProspecto,
  getProspectoById,
  deleteProspecto,
} = require("../controllers/Prospectos.Controller");

const router = Router();

router.get("/:distribuidor", getProspectos);

router.get("/:id/byId", getProspectoById);

router.post("/:distribuidor", createProspecto);

router.put("/:id", updateProspecto);
router.put("/:distribuidor/contador", addCountProspecto);

router.delete("/:id", deleteProspecto);

module.exports = router;
