const { Router } = require('express');
const {
  crearPromotor,
  obtenerPromotores,
  obtenerPromotorPorId,
  enviarCredenciales,
  actualizarPromotor
} = require('../controllers/Promotores.Controller');
const router = Router();

router.get('/:distribuidor', obtenerPromotores);
router.get('/:id/byId', obtenerPromotorPorId);

router.post('/accesos', enviarCredenciales);

router.put('/:id', actualizarPromotor);

router.post('/', crearPromotor);

module.exports = router;
