const { Router } = require('express');
const { createMensaje, obtenerMensajesForCLiente, contadorTotalMensajes, obtenerHistorialDespachoMensajes, obtenerHistorialClienteMensajes, obtenerMensajesForDespacho, cerrarChat } = require('../controllers/mensajes.Controller.js');

const router = Router();

router.post('/', createMensaje);

router.get('/cliente/:cliente', obtenerMensajesForCLiente);

router.get('/despacho/:despacho', obtenerMensajesForDespacho);

router.get('/contador', contadorTotalMensajes);

router.get('/historial/:chatRoom', obtenerHistorialClienteMensajes);

router.get('/historial-despacho/:chatRoom', obtenerHistorialDespachoMensajes);

router.patch('/cerrar/:_id', cerrarChat);

module.exports = router;
