const { Router } = require('express');
const { getMaterias, getMateriasSinPaginar, createMateria, getMateriaById, updateMateria, deleteMateria } = require('../controllers/Materias.Controller.js');

const router = Router();

router.get('/sin-paginar', getMateriasSinPaginar);
router.get('/', getMaterias);
router.post('/', createMateria);
router.get('/:id', getMateriaById);
router.put('/:id', updateMateria);

router.delete('/:id', deleteMateria)

module.exports = router;
