const { Router } = require('express');
const { getMaterias, getMateriasSinPaginar, createMateria, getMateriaById, updateMateria, deleteMateria } = require('../controllers/MateriasDespacho.Controller.js');

const router = Router();

router.get('/:despacho/by-id/:id', getMateriaById);
router.get('/:despacho/sin-paginar', getMateriasSinPaginar);
router.get('/:despacho', getMaterias);
router.post('/:despacho', createMateria);
router.put('/:despacho/by-id/:id', updateMateria);
router.delete('/:despacho/by-id/:id', deleteMateria);

module.exports = router;
