const { Router } = require("express");
const {
  getPaquete,
  createPaquete,
  deletePaquete,
  getPaqueteById,
  updatePaquete,
  getPaqueteSinPaginar,
} = require("../controllers/Paquetes.Licencias.Controller.js");

const router = Router();

router.get("/", getPaquete);
router.get("/sin-paginar", getPaqueteSinPaginar);

router.get("/:id", getPaqueteById);
router.post("/", createPaquete);
router.put("/:id", updatePaquete);
router.delete("/:id", deletePaquete);

module.exports = router;
