const { Router } = require('express');
const { getLegislaciones, createLegislacion, updateLegislacion, getLegislacionById, deleteLegislacion, generateExcel } = require('../controllers/Legislaciones.Controller.js');

const router = Router();

router.get('/excel', generateExcel);
router.get('/', getLegislaciones);
router.post('/', createLegislacion);
router.get('/:id', getLegislacionById);
router.put('/:id', updateLegislacion);
router.delete('/:id', deleteLegislacion);

module.exports = router;
