const { Router } = require('express');
const { getJuzgados, getJuzgadosSinPaginar, createJuzgado, deleteJuzgado, generateExcelEstadosMunicipios, getJuzgadosById, updateJuzgado, generateExcel } = require('../controllers/Juzgados.Controller.js');

const router = Router();

router.get('/excel', generateExcel);
router.get('/excel-estados-municipios', generateExcelEstadosMunicipios);
router.get('/', getJuzgados);
router.get('/sin-paginar', getJuzgadosSinPaginar);
router.post('/', createJuzgado);
router.delete('/:id', deleteJuzgado);
router.put('/:id', updateJuzgado);
router.get('/:id', getJuzgadosById);

module.exports = router;
