const { Router } = require('express');
const { getJurisprudencia, getJurisprudenciaById, getPdf, downloadPDF } = require('../controllers/Jurisprudencia.Controller');

const router = Router();

router.get('/', getJurisprudencia); // Obtener todos los resultados de jurisprudencia con respecto a la búsqueda
// router.get('/ordenar', getOrdenamiento); // Obtener datos para el autocomplete de ordenar
router.get('/pdf', getPdf); // Obtener el pdf (sentencia, votos , resumen)
router.get('/download-pdf', downloadPDF); // Obtener datos de un solo documento
router.get('/:id', getJurisprudenciaById); // Obtener datos de un solo documento

module.exports = router;
