const { Router } = require('express');
const { getIngresos, createIngresos, deleteComprobante, getExpedientesSinPaginar, getClientes, deleteIngresos, getIngresoById } = require('../controllers/Ingresos.Controller.js');

const router = Router();

router.get('/:despacho', getIngresos);
router.post('/:despacho', createIngresos);
router.get('/expedientes/:despacho', getExpedientesSinPaginar);
router.get('/clientes/:despacho', getClientes);
router.delete('/:id', deleteIngresos);
router.get('/ingreso/:id', getIngresoById);
router.delete('/comprobante/:id', deleteComprobante);

module.exports = router;
