const Router = require('express');
const { readdirSync } = require('fs');

require('colors');

const router = Router();

const pathRouter = __dirname;

const removeExtension = (fileName) => {
  return fileName.split('.').shift();
};

// Ruta raíz
router.get('/', (req, res) => {
  res.send('¡Bienvenido a la API!');
});

console.log('Cargando rutas dinámicas...');

// Cargar rutas dinámicamente desde la carpeta actual
readdirSync(pathRouter).filter((file) => {
  const fileWithOutExt = removeExtension(file);
  const skip = ['index'].includes(fileWithOutExt);
  if (!skip) {
    console.log(`Cargando ruta: /${fileWithOutExt}`);  // Log para verificar
    router.use(`/${fileWithOutExt}`, require(`./${fileWithOutExt}`));
  }
});

module.exports = router;
