const { Router } = require('express');
const { createExpediente, getExpedientesByUsuarioSinPaginate, getExpedientesByUsuario, getPermisosExpediente, getExpedienteById, updateEstatus, updateTitulo, updateNumeroExpediente, updateJuicio, updateEtapaProcesal, deleteExpediente, getExpedienteByCliente, getExpedienteByID, getJuzgadosByExpedientes, updateFechaInicio, updateFechaFinal, updateJuzgado, createExpedienteFile } = require('../controllers/Expedientes.Controller.js');
const router = Router();
router.get('/pdf/:despacho/:expediente', createExpedienteFile);

router.get('/:despacho/juzgados', getJuzgadosByExpedientes);

// Ruta base común para el despacho y usuario
router.get('/:expediente/by-id', getExpedienteByID);
router.post('/:despacho', createExpediente);
router.get('/:cliente/cliente', getExpedienteByCliente);
router.get('/:despacho/:usuario', getExpedientesByUsuario);
router.get('/:despacho/:usuario/sin-paginar', getExpedientesByUsuarioSinPaginate);

// Ruta para obtener un expediente por ID
router.get('/:despacho/:usuario/:expediente', getExpedienteById);

// Ruta para obtener los permisos de un expediente
router.get('/:despacho/:usuario/:expediente/permisos', getPermisosExpediente);

// Ruta para DEVOLVER UN HTML DE UN EXPEDIENTE

// Rutas para actualizar diferentes campos de un expediente
router.patch('/:despacho/:usuario/:expediente/estatus', updateEstatus);
router.patch('/:despacho/:usuario/:expediente/titulo', updateTitulo);
router.patch('/:despacho/:usuario/:expediente/numero', updateNumeroExpediente);
router.patch('/:despacho/:usuario/:expediente/juicio', updateJuicio);
router.patch('/:despacho/:usuario/:expediente/etapa', updateEtapaProcesal);
router.patch('/:despacho/:usuario/:expediente/fecha-inicio', updateFechaInicio);
router.patch('/:despacho/:usuario/:expediente/fecha-final', updateFechaFinal);
router.patch('/:despacho/:usuario/:expediente/juzgado', updateJuzgado);
router.delete('/:despacho/:expediente', deleteExpediente);
// Ruta para obtener un expediente por ID

module.exports = router;
