const { Router } = require("express");
const {
  getRecursosIncidencias,
  nuevoRecursoIncidencia,
  eliminarRecursoIncidencia,
  actualizarRecursoIncidencia,
} = require("../controllers/Expedientes.Incidencias.Controller.js");

const router = Router();

router.get("/:despacho/:expediente", getRecursosIncidencias);
router.post("/:despacho/:expediente", nuevoRecursoIncidencia);

router.delete("/:despacho/:expediente/:_id", eliminarRecursoIncidencia);
router.patch("/:despacho/:expediente/:_id", actualizarRecursoIncidencia);

module.exports = router;
