const { Router } = require('express');
const { getMateriaNoAsignadas, getFolios, createFolio, deleteFolio, proximoFolio, proximoFolioSinMateria } = require('../controllers//Expedientes.Folios.js');

const router = Router();

router.get('/:despacho/sin-asignar', getMateriaNoAsignadas);
router.get('/:despacho', getFolios);
router.get('/proximo/:materia', proximoFolio);
router.post('/:despacho', createFolio);
router.delete('/:id', deleteFolio);
router.get('/proximo-sin-materia/:despacho', proximoFolioSinMateria);

module.exports = router;
