const { Router } = require('express');
const { getEtapasProcesales, getEtapasProcesalesSinPagina, getMateriasEtapas, createEtapaProcesal, updateEtapaProcesal, getEtapaProcesalById, deleteEtapaProcesal } = require('../controllers/EtapasProcesales.Controller.js');

const router = Router();

router.get('/', getEtapasProcesales);
router.get('/sin-pagina', getEtapasProcesalesSinPagina);
router.get('/materias', getMateriasEtapas);
router.get('/:id', getEtapaProcesalById);

router.post('/', createEtapaProcesal)
router.put('/:id', updateEtapaProcesal)

router.delete('/:id', deleteEtapaProcesal)

// router.post('/:despacho', createCliente);
module.exports = router;
