const { Router } = require('express');
const { obtenerInformacioDistribuidor, actualizarRetirarFondos, findDistribuidorForClave, generateDistribuidorRegistroPruebas, findDistribuidorForClaveProspecto, ConvertirProspectoDistribuidor, generateDistribuidorRegistroProspecto } = require('../controllers/Usuarios.Controller.js');
const { getVentasByDistribuidores } = require('../controllers/Distribuidores.Controller.js');

const router = Router();

router.get('/:id', obtenerInformacioDistribuidor);
router.put('/:id', actualizarRetirarFondos);
router.get('/clave/:clave', findDistribuidorForClave);
router.get('/clave/prospecto/:clave', findDistribuidorForClaveProspecto);
router.post('/registro/pruebas', generateDistribuidorRegistroPruebas);
router.post('/registro/prospecto', generateDistribuidorRegistroProspecto);
router.post('/convertir/prospecto', ConvertirProspectoDistribuidor);
router.get('/:usuario/ventas', getVentasByDistribuidores);

module.exports = router;
