const { Router } = require('express');
const { getDespachos, createDespachoRegistro, getDespachoById, updateDespacho, deleteDespacho, updateEstatus } = require('../controllers/Despachos.Psd.Controller.js');

const router = Router();

router.get('/', getDespachos);
router.get('/:id', getDespachoById);

router.post('/', createDespachoRegistro);

router.put('/:id', updateDespacho);

router.delete('/:id', deleteDespacho);

router.patch('/estatus', updateEstatus);

module.exports = router;
