const { Router } = require('express');
const { getDespachos, getVentasByDespacho, getDespachosSinPaginar, getDespachosSinPaginarVencidos, createDespachoDistribuidor } = require('../controllers/Despachos.Distribuidores.Controller.js');

const router = Router();

router.get('/sin-paginar/:distribuidor', getDespachosSinPaginar);
router.get('/:distribuidor', getDespachos);
router.get('/:distribuidor/vencidos', getDespachosSinPaginarVencidos);
router.get('/:despacho/:distribuidor/ventas', getVentasByDespacho);
router.post('/:distribuidor', createDespachoDistribuidor);

module.exports = router;
