const { Router } = require('express');
const { getDependencias, createDependencia, getDependenciaById, updateDependencia, deleteDependencia } = require('../controllers/DependenciasController.js');
const router = Router();

router.get('/', getDependencias);
router.post('/', createDependencia);
router.get('/:id', getDependenciaById);
router.put('/:id', updateDependencia);
router.delete('/:id', deleteDependencia);

module.exports = router;
