const { Router } = require("express");
const {
  getDeclaracionFiscal,
  creteDeclaracionFiscal,
  deleteDeclaracionFiscal,
  getDeclaracionFiscalById,
  updateDeclaracionFiscal,
  declaracionFiscalPDF,
} = require("../controllers/Declaraciones.Fiscales.Controller.js");
const router = Router();

router.get("/pdf/:despacho", declaracionFiscalPDF);

router.get("/:despacho", getDeclaracionFiscal);
router.post("/:despacho", creteDeclaracionFiscal);
router.delete("/:id", deleteDeclaracionFiscal);
router.get("/:id/by-id", getDeclaracionFiscalById);
router.patch("/:id", updateDeclaracionFiscal);

module.exports = router;
