const { Router } = require('express');
const { getFavoritos, createFavorito, getById, deleteFavorito, createOrDeleteFavoritoChat } = require('../controllers/Busqueda.Favoritos.Controller.js');

const router = Router();

router.get('/:despacho', getFavoritos);
router.post('/chat', createOrDeleteFavoritoChat);
router.post('/:despacho', createFavorito);
router.get('/:despacho/:tipo/:id', getById);
router.delete('/:despacho/:tipo/:id', deleteFavorito);

module.exports = router;
