const { Router } = require('express');
const { createAlertas, getAlertas, getAlertaById, updateAlerta, updateAlertaEstatus, deleteAlerta } = require('../controllers/Alertas.Controller.js');

const router = Router();

router.post('/:despacho', createAlertas);
router.get('/:despacho/created-by-me', getAlertas);
router.get('/:id/by-id', getAlertaById);
router.patch('/:id', updateAlerta);
router.delete('/:id', deleteAlerta);
router.patch('/:id/estatus', updateAlertaEstatus);

module.exports = router;
