const { Router } = require('express');
const { createEvent, getEvents, updateEvent, getEventosByExpediente, getEventosClientes, deleteEvento, getEventByID } = require('../controllers/Expedientes.Agenda.Controller.js');

const router = Router();

router.get('/:id/by-id', getEventByID);
router.get('/:expediente/expediente', getEventosByExpediente);
router.get('/:cliente/cliente', getEventosClientes);
router.get('/:despacho/:usuario', getEvents);
router.post('/:despacho/:usuario', createEvent);
router.put('/', updateEvent);
router.delete('/:idEvento/:idRecordatorio', deleteEvento);

module.exports = router;
