const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const messageSchema = new Schema({
  chatRoom: {
    type: Schema.Types.ObjectId,
    ref: 'chatRooms',
    required: true
  },
  enviadoPor: {
    type: String,
    enum: ['Despacho', 'Cliente'],
    required: true
  },
  usuario: {
    type: Schema.Types.ObjectId,
    ref: 'usuarios',
    required: false
  },
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'despachos',
    required: false
  },
  cliente: {
    type: Schema.Types.ObjectId,
    ref: 'clientes',
    required: false
  },
  mensaje: {
    type: String,
    required: false,
    default: ''
  },
  archivos: [
    {
      nombre: {
        type: String,
        required: false
      },
      archivo: {
        type: String,
        required: false
      }
    }
  ],
  fechaCreacion: {
    type: Date,
    default: Date.now
  },
  vistoPor: {
    cliente: {
      type: Boolean,
      default: false
    },
    despacho: {
      type: Boolean,
      default: false
    }
  }
}, {
  versionKey: false
});

messageSchema.plugin(mongoosePaginate);

module.exports = model('mensajes', messageSchema);
