const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const MachotesSchema = new Schema({
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'despachos',
    required: true
  },
  creador: {
    type: Schema.Types.ObjectId,
    ref: 'usuarios',
    required: true
  },
  nombre: {
    type: String,
    required: true
  },
  descripcion: {
    type: String,
    required: false,
    default: ''
  },
  archivos: [{
    nombre: {
      type: String,
      required: true
    },
    ruta: {
      type: String,
      required: true
    }
  }],
  usuariosCompartidos: [{
    type: Schema.Types.ObjectId,
    ref: 'usuarios',
    required: false
  }],
  estatus: {
    type: String,
    enum: ['Activo', 'Inactivo'],
    required: true,
    default: 'Activo'
  },
  fechaCreacion: {
    type: Date,
    required: true,
    default: Date.now
  }

}, {
  versionKey: false
});

MachotesSchema.plugin(mongoosePaginate);

// indexs
MachotesSchema.index({
  despacho: 1,
  nombre: 1,
  creador: 1,
  estatus: 1,
  fechaCreacion: 1
});

module.exports = model('machotes', MachotesSchema);
