const mongoose = require('mongoose');
const Schema = mongoose.Schema;
const mongoosePaginate = require('mongoose-paginate-v2');

// Definir el esquema del archivo
const firmaSchema = new Schema({
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'despachos',
    required: true,
    index: true
  },
  nombreDocumento: {
    type: String,
    required: true,
    trim: true
  },
  documentoOriginal: { // clave file
    type: String,
    required: true,
    trim: true
  },
  creadoPor: {
    type: Schema.Types.ObjectId,
    ref: 'usuarios',
    required: true,
    index: true
  },
  usuarios: [
    {
      usuario: {
        type: Schema.Types.ObjectId,
        ref: 'usuarios',
        require: true
      },
      estatus: {
        type: String,
        enum: ['Firmado', 'Sin firmar', 'Rechazado'],
        default: 'Sin firmar'
      },
      fechaFirmado: {
        type: Date,
        default: null
      },
      firma: {
        type: String,
        require: false,
        default: null
      },
      comentario: {
        type: String,
        require: false,
        default: null
      }
    }
  ],
  clientes: [
    {
      cliente: {
        type: Schema.Types.ObjectId,
        ref: 'clientes',
        require: true
      },
      estatus: {
        type: String,
        enum: ['Firmado', 'Sin firmar', 'Rechazado'],
        default: 'Sin firmar'
      },
      fechaFirmado: {
        type: Date,
        default: null
      },
      firma: {
        type: String,
        require: false,
        default: null
      },
      comentario: {
        type: String,
        require: false,
        default: null
      }
    }
  ],
  prospectos: [
    {
      prospecto: {
        type: Schema.Types.ObjectId,
        ref: 'prospectosDespacho',
        require: true
      },
      estatus: {
        type: String,
        enum: ['Firmado', 'Sin firmar', 'Rechazado'],
        default: 'Sin firmar'
      },
      fechaFirmado: {
        type: Date,
        default: null
      },
      firma: {
        type: String,
        require: false,
        default: null
      },
      comentario: {
        type: String,
        require: false,
        default: null
      }
    }
  ],
  recordatorio: {
    type: String,
    enum: ['Día', 'Tres días', 'Semana', null],
    default: null,
    required: false
  },
  documentoFirmado: {
    type: String,
    default: null
  },
  zip: {
    type: String,
    default: null
  },
  fechaExpiracion: {
    type: Date
  },
  creadoFecha: {
    type: Date,
    default: Date.now
  },
  firmado: {
    type: Date,
    default: null
  },
  estatus: {
    type: String,
    enum: ['Firmado', 'En proceso', 'Rechazado'],
    default: 'En proceso'
  },
  ultimaFechaEnvio: {
    type: Date,
    default: null
  }
});

firmaSchema.plugin(mongoosePaginate);

module.exports = mongoose.model('firmaDocumentos', firmaSchema);
