const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const chatRoomSchema = new Schema({
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'despachos',
    required: true
  },
  cliente: {
    type: Schema.Types.ObjectId,
    ref: 'clientes',
    required: true
  },
  fechaCreacion: {
    type: Date,
    default: Date.now
  },
  titulo: {
    type: String,
    required: true
  },
  estatus: {
    type: String,
    enum: ['Abierto', 'Cerrado'],
    required: true,
    default: 'Abierto'
  }
}, {
  versionKey: false
});

chatRoomSchema.plugin(mongoosePaginate);

module.exports = model('chatRoom', chatRoomSchema);
