const { Schema, model } = require("mongoose");
const mongoosePaginate = require("mongoose-paginate-v2");

const VentasSchema = new Schema(
  {
    despacho: {
      type: Schema.Types.ObjectId,
      ref: "despachos",
      required: false,
      index: true,
    },
    usuario: {
      type: Schema.Types.ObjectId,
      ref: "usuarios",
      required: false,
      index: true,
    },
    fechaVenta: {
      type: Date,
      required: true,
      default: Date.now,
    },
    producto: {
      type: Schema.Types.ObjectId,
      ref: "productos",
      required: true,
      index: true,
    },
    importe: {
      type: Number,
      required: true,
    },
    fecha_pago: {
      type: Date,
      required: false,
      index: true,
      default: Date.now,
    },
    formaPago: {
      type: String,
      required: false,
      default: "",
    },
    referencia: {
      // order conekta
      type: String,
      required: false,
      default: "",
      index: true,
    },
    tipoReferencia: {
      type: String,
      required: false,
      enum: [
        "Conekta",
        "Paypal",
        "Oxxo",
        "Tarjeta",
        "Efectivo",
        "Stripe",
        "Gratis",
      ],
      index: true,
    },
    estatus: {
      type: String,
      enum: ["Pagado", "Pendiente", "Facturada"],
      required: true,
      default: "Pendiente",
      index: true,
    },
    who: {
      ///Es el identificador del vendedor directo
      type: Schema.Types.ObjectId,
      ref: "usuarios",
      required: false,
      default: null,
    },
    distribuidor: {
      comision: {
        type: Number,
        required: false,
        default: 0,
      },
      distribuidor: {
        type: Schema.Types.ObjectId,
        ref: "usuarios",
        required: false,
        default: null,
      },
      importe: {
        type: Number,
        required: false,
        default: 0,
      },
      corte: {
        type: Schema.Types.ObjectId,
        ref: "corteDistribuidores",
        required: false,
        default: null,
      },
    },
    vendedor: {
      comision: {
        type: Number,
        required: false,
        default: 0,
      },
      vendedor: {
        type: Schema.Types.ObjectId,
        ref: "usuarios",
        required: false,
        default: null,
      },
      importe: {
        type: Number,
        required: false,
        default: 0,
      },
    },

    promotor: {
      comision: {
        type: Number,
        required: false,
        default: 0,
      },
      promotor: {
        type: Schema.Types.ObjectId,
        ref: "usuarios",
        required: false,
        default: null,
      },
      importe: {
        type: Number,
        required: false,
        default: 0,
      },
    },
  },
  {
    versionKey: false,
  }
);

VentasSchema.plugin(mongoosePaginate);
module.exports = model("ventas", VentasSchema);
