const { Schema, model } = require("mongoose");
const mongoosePaginate = require("mongoose-paginate-v2");

const UsuariosSchema = new Schema(
  {
    clave: {
      // solo para distribuidores
      type: String,
      required: false,
      index: true,
    },
    nombre: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    fechaNacimiento: {
      type: Date,
      required: false,
      default: null,
    },
    apellidoPaterno: {
      type: String,
      required: false,
      default: "",
      trim: true,
    },
    apellidoMaterno: {
      type: String,
      required: false,
      default: "",
      trim: true,
    },
    telefono: {
      type: String,
      trim: true,
    },
    email: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    password: {
      type: String,
      required: false,
      index: true,
    },
    foto: {
      type: String,
      required: false,
      default: "",
    },
    // tipoUsuario: {
    //   type: Schema.Types.ObjectId,
    //   ref: 'tipoUsuarios',
    //   required: false,
    //   default: undefined
    // },
    tipo: {
      type: String,
      // enum: ['despacho', 'distribuidor'], // Solo se ocupo para los prospectos
      required: false,
      default: undefined,
    },
    // tipo: {
    //   type: String,
    //   enum: ['admin', 'despacho', 'distribuidor'],
    //   required: false,
    //   default: undefined
    // },
    tipoUsuarios: {
      admin: {
        type: Schema.Types.ObjectId,
        ref: "tipoUsuarios",
        required: false,
        default: undefined,
      },
      despacho: {
        type: Schema.Types.ObjectId,
        ref: "tipoUsuarios",
        required: false,
        default: undefined,
      },
      distribuidor: {
        type: Schema.Types.ObjectId,
        ref: "tipoUsuarios",
        required: false,
        default: undefined,
      },
      promotor: {
        type: Schema.Types.ObjectId,
        ref: "tipoUsuarios",
        required: false,
        default: undefined,
      },
      vendedor: {
        type: Schema.Types.ObjectId,
        ref: "tipoUsuarios",
        required: false,
        default: undefined,
      },
    },
    token: {
      type: String,
      required: false,
      default: "",
    },
    despacho: {
      type: Schema.Types.ObjectId,
      ref: "despachos",
      required: false,
      index: true,
    },
    tour: {
      type: Boolean,
      required: false,
      default: false,
      index: true,
    },
    estatus: {
      type: String,
      enum: ["Activo", "Inactivo", "Prospecto", "Eliminado"],
      required: true,
      default: "Activo",
      index: true,
    },

    licencia: {
      // solo para distribuidores actual corriendo
      licenciaFree: {
        type: Boolean,
        required: false,
        default: false,
      },
      producto: {
        type: Schema.Types.ObjectId,
        ref: "productos",
        required: false,
        default: undefined,
      },
      vigencia: {
        type: Date,
        required: false,
        default: undefined,
      },
      referidoPor: {
        type: Schema.Types.ObjectId,
        ref: "usuarios",
        required: false,
        default: undefined,
      },
      comision: {
        type: Number,
        required: false,
        default: 0,
      },
    },
    rfc: {
      type: String,
      required: false,
    },
    comprobantes: {
      constancia: {
        type: String,
        required: false,
      },
      ine: {
        frontal: {
          type: String,
          required: false,
        },
        trasera: {
          type: String,
          required: false,
        },
      },
      domicilio: {
        type: String,
        required: false,
      },
    },
    fechaCreacion: {
      type: Date,
      default: new Date(),
      required: true,
    },
    ultimoAcceso: {
      type: Date,
      required: false,
      default: null,
    },
    googleId: {
      type: String,
      required: false,
    },
  },
  {
    versionKey: false,
  }
);

// Pre-save hook to generate distributor key
UsuariosSchema.pre("save", async function (next) {
  if (
    this.tipoUsuarios &&
    (this.tipoUsuarios.vendedor ||
      this.tipoUsuarios.promotor ||
      this.tipoUsuarios.distribuidor) &&
    !this.clave &&
    this.estatus === "Activo"
  ) {
    try {
      let inicial = "";

      if (this.tipoUsuarios.vendedor) inicial = "VEN-IUS-";
      if (this.tipoUsuarios.promotor) inicial = "PRO-IUS-";
      if (this.tipoUsuarios.distribuidor) inicial = "DIS-IUS-";

      // Obtener el último usuario con el formato adecuado, usando `inicial`
      const lastUser = await this.constructor
        .findOne({
          clave: { $regex: `^${inicial}(\\d{4})$` },
        })
        .sort({ clave: -1 });

      let nextNumber = 1;
      if (lastUser) {
        const lastNumber = parseInt(lastUser.clave.split("-")[2], 10);
        nextNumber = lastNumber + 1;
      }

      // Formatear el número con ceros a la izquierda
      const formattedNumber = nextNumber.toString().padStart(4, "0");
      this.clave = `${inicial}${formattedNumber}`;
    } catch (error) {
      return next(error);
    }
  }
  next();
});

UsuariosSchema.plugin(mongoosePaginate);
module.exports = model("usuarios", UsuariosSchema);
