const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const TourSchema = new Schema({
  target: {
    type: String,
    required: true
  },
  content: {
    type: String,
    required: true
  },
  title: {
    type: String,
    required: true
  },
  placement: {
    type: String,
    enum: ['top', 'top-start', 'top-end', 'bottom', 'bottom-start', 'bottom-end', 'left', 'left-start', 'left-end', 'right', 'right-start', 'right-end'],
    required: false,
    default: 'top'
  },
  orden: {
    type: Number,
    required: false,
    default: 1
  },
  estatus: {
    type: String,
    enum: ['Activo', 'Inactivo'],
    default: 'Activo'
  }
}, {
  versionKey: false
});

TourSchema.plugin(mongoosePaginate);
module.exports = model('tour', TourSchema);
