const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const RecursosIncidencias = new Schema({
  nombre: {
    type: String,
    required: true
  },
  materia: {
    type: Schema.Types.ObjectId,
    ref: 'materias',
    required: true,
    index: true
  },
  tipo: {
    type: String,
    enum: ['Recurso', 'Incidencia'],
    required: true
  },
  estatus: {
    type: String,
    enum: ['Activo', 'Inactivo'],
    default: 'Activo'
    // required: true
  }
}, {
  versionKey: false
});

RecursosIncidencias.plugin(mongoosePaginate);
module.exports = model('recursosIncidencias', RecursosIncidencias);
