const { Schema, model } = require("mongoose");

const QueryField = new Schema(
  {
    name: {
      type: String,
      required: true,
      index: true,
    },
    tooltip: {
      type: String,
      required: true,
    },
    value: {
      type: String,
      required: true,
    },
    type: {
      type: Number,
      required: true,
    },
    order: {
      type: Number,
      required: true,
    },
    checked: {
      type: Boolean,
      required: true,
      default: true,
    },
  },
  {
    versionKey: false,
  }
);

module.exports = model("queryFields", QueryField);
