const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const ProspectoSchema = new Schema({
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'despachos',
    required: true
  },
  nombre: {
    type: String,
    required: true,
    trim: true
  },
  correo: {
    type: String,
    required: false,
    default: '',
    index: true
  },
  telefono: {
    type: String,
    required: false,
    default: ''
  }
}, {
  versionKey: false
});

ProspectoSchema.plugin(mongoosePaginate);
ProspectoSchema.index({ despacho: 1, nombre: 1 });

module.exports = model('prospectosDespacho', ProspectoSchema);
