const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const ProductosSchema = new Schema({
  tipo_producto: {
    type: String,
    enum: ['Paquete', 'Plantilla', 'Timbres', 'GPT-4', 'Licencia'],
    required: true
  },
  nombre: {
    type: String,
    required: true
  },
  tiempo: { // En días para los paquetes
    type: Number,
    required: false,
    default: 0
  },
  pruebaGratis: {
    type: Boolean,
    required: false,
    default: false
  },
  imagen: {
    type: String,
    required: true
  },
  precio: {
    type: Number,
    required: true
  },
  cantidad: { // En caso de ser timbres o expedientes
    type: Number,
    required: false,
    default: 0
  },
  // descripcion: {
  //   type: String,
  //   required: false,
  //   default: ''
  // },
  archivo: {
    type: String,
    required: false,
    default: ''
  },
  claveSAT: {
    type: String,
    required: false,
    default: ''
  },
  claveUMSAT: {
    type: String,
    required: false,
    default: ''
  },
  tasa: {
    type: Number,
    required: false,
    default: 0
  },
  estatus: {
    type: String,
    enum: ['Activo', 'Inactivo', 'Exclusivo'],
    required: true,
    default: 'Activo'
  },
  recomendado: {
    type: Boolean,
    required: false,
    default: false
  },
  beneficios: {
    type: Array,
    required: false,
    default: []
  },
  // inversion: {// lo mismo que el precio
  //   type: Number,
  //   required: false,
  //   default: 0
  // },
  utilidad: {
    type: Number,
    required: false,
    default: 0
  },
  imagenPrincipal: {
    type: String,
    required: false,
    default: null
  },
  colorTabla: {
    type: String,
    required: false,
    default: ''
  },
  param: {
    type: String,
    required: false,
    default: ''
  },
  adjunto: {
    type: String,
    required: false,
    default: null
  },
  mostrarPublico: {
    type: Boolean,
    required: false,
    default: true
  }

}, {
  versionKey: false
});

ProductosSchema.plugin(mongoosePaginate);

module.exports = model('productos', ProductosSchema);
