const { Schema, model } = require('mongoose');
const PoderJudicialEstadoSchema = new Schema({
  estado: {
    type: Schema.Types.ObjectId,
    ref: 'estados',
    required: true
  },
  nombre: {
    type: String,
    required: true
  },
  url: {
    type: String,
    required: true
  },
  estatus: {
    type: String,
    required: true,
    enum: ['Activo', 'Inactivo'],
    default: 'Activo'
  }
}, {
  versionKey: false
});

module.exports = model('poderJudicialEstado', PoderJudicialEstadoSchema);
