const { Schema, model } = require('mongoose');

const ModulosSchema = new Schema({
  nombre: {
    type: String,
    required: true
  },
  enlace: {
    type: String,
    required: true,
    index: true
  },
  imagen: {
    type: String,
    required: true
  },
  orden: {
    type: Number,
    required: true
  },
  padre: {
    type: String,
    default: ''
  },
  permisosAdmin: {
    type: Object,
    default: {
      create: false,
      read: false,
      update: false,
      delete: false
    }
  },
  estatus: {
    type: String,
    enum: ['Activo', 'Inactivo'],
    required: true,
    index: true,
    default: 'Activo'
  },
  tipo: {
    type: String,
    enum: ['admin', 'despacho'],
    default: 'admin',
    index: true
  },
  target: { // para react-joyride (tour)
    type: String,
    default: ''
  },
  // abierto por default
  abierto: {
    type: Boolean,
    default: undefined
  }

}, {
  versionKey: false
});

module.exports = model('modulos', ModulosSchema);
