const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const MateriasDespachoSchema = new Schema({
  nombre: {
    type: String,
    required: true,
    index: true
  },
  estatus: {
    type: String,
    enum: ['Activo', 'Inactivo'],
    default: 'Activo',
    required: true,
    index: true
  },
  // materia: {
  //   type: Schema.Types.ObjectId,
  //   ref: 'materias',
  //   required: true,
  //   index: true
  // },
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'despachos',
    required: true,
    index: true
  }
}, {
  versionKey: false
});

MateriasDespachoSchema.index({ nombre: 1, despacho: 1, estatus: 1 });

MateriasDespachoSchema.plugin(mongoosePaginate);
module.exports = model('materiasDespachos', MateriasDespachoSchema);
