const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');
const { formatDateTime } = require('../config/functionsGlobal.js');
const MailMasivoSchema = new Schema({
  usuario: {
    type: Schema.Types.ObjectId,
    ref: 'usuarios',
    required: false,
    default: null
  },
  subject: {
    type: String,
    trim: true,
    require: true
  },
  correos: [{
    type: String,
    trim: true
  }],
  invitarA: {
    type: String
  },
  activosRegistros: {
    type: Boolean,
    default: false
  },
  linkConferencia: {
    type: String,
    default: null
  },
  texto: {
    type: String,
    default: null
  },
  fechaCreacion: {
    type: Date,
    default: new Date()
  },
  fechaInicio: {
    type: Date,
    default: null
  },
  invitados: [{
    nombre: {
      type: String,
      require: false,
      default: null,
      trim: true
    },
    correo: {
      type: String,
      require: true,
      trim: true
    },
    telefono: {
      type: String,
      require: false,
      default: null,
      trim: true
    },
    invitacion: {
      type: Boolean,
      default: false
    }
  }],
  clave: {
    type: String,
    unique: true
  }
}, {
  versionKey: false
});

// Función para generar una clave única
const generarClaveUnica = () => {
  const segmentos = [];
  for (let i = 0; i < 3; i++) {
    segmentos.push(Math.random().toString(36).substring(2, 6));
  }
  return segmentos.join('-');
};

// Middleware pre-save para generar la clave antes de guardar
MailMasivoSchema.pre('save', function (next) {
  if (!this.clave) { // Solo genera una clave si no existe
    this.clave = generarClaveUnica();
  }
  next();
});

// Modificar la salida JSON para incluir la fecha formateada
MailMasivoSchema.method('toJSON', function () {
  const { fechaCreacion, ...obj } = this.toObject();
  return {
    ...obj,
    fechaCreacionFormateada: formatDateTime(fechaCreacion)
  };
});

MailMasivoSchema.plugin(mongoosePaginate);

module.exports = model('mailMasivo', MailMasivoSchema);
