const { Schema, model } = require('mongoose');

const JurisprudenciaOrdenar = new Schema(
  {
    nombre: {
      type: String,
      required: true,
      index: true
    },
    label: {
      type: String,
      required: true,
      index: true
    },
    value: {
      type: String,
      required: true
    },
    estatus: {
      type: String,
      enum: ['Activo', 'Inactivo'],
      required: true,
      default: 'Activo',
      index: true
    }
  },
  {
    versionKey: false
  }
);

module.exports = model('jurisprudenciaordenars', JurisprudenciaOrdenar);
