const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const incidenciasDespachos = new Schema({
  nombre: {
    type: String,
    required: true,
    index: true
  },
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'despachos',
    required: true
  },
  materia: {
    type: Schema.Types.ObjectId,
    ref: 'materiasDespachos',
    required: true
  },
  estatus: {
    type: String,
    enum: ['Activo', 'Inactivo'],
    default: 'Activo'
  }
}, {
  versionKey: false
});

incidenciasDespachos.index({ nombre: 1, despacho: 1 });

incidenciasDespachos.plugin(mongoosePaginate);
module.exports = model('incidenciasDespachos', incidenciasDespachos);
