const mongoose = require('mongoose');
const Schema = mongoose.Schema;

// Definir el esquema del archivo
const fileSchema = new Schema({
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'Despacho',
    required: true,
    index: true
  },
  expediente: {
    type: Schema.Types.ObjectId,
    ref: 'Expediente',
    required: true,
    index: true
  },
  filename: {
    type: String,
    required: true,
    trim: true
  },
  fileType: {
    type: String,
    required: true,
    trim: true
  },
  size: {
    type: Number,
    required: true
  },
  url: {
    type: String,
    required: true,
    trim: true
  },
  folder: {
    type: Schema.Types.ObjectId,
    ref: 'ExpedienteFolder',
    default: null,
    index: true // Añadir índice aquí
  },
  createdAt: {
    type: Date,
    default: Date.now
  },
  lastModified: {
    type: Date,
    default: Date.now
  }
});

// Crear el modelo del archivo
// const File = mongoose.model('File', fileSchema);

module.exports = mongoose.model('File', fileSchema);
