const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const ExpedienteUsuariosConectados = new Schema({
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'despachos',
    required: true,
    index: true
  },
  expediente: {
    type: Schema.Types.ObjectId,
    ref: 'expedientes',
    required: true,
    index: true
  },
  usuarios: [{
    type: Schema.Types.ObjectId,
    ref: 'usuarios',
    required: true
  }],
  fecha: {
    type: Date,
    required: true
  }
}, {
  versionKey: false
});

ExpedienteUsuariosConectados.plugin(mongoosePaginate);
module.exports = model('expedienteUsuariosConectados', ExpedienteUsuariosConectados);
